/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.model.RecipientListDefinition;
import org.junit.jupiter.api.Test;

public class RecipientListDirectNoConsumerIssueTest
extends ContextTestSupport {
    @Test
    public void testDirectNoConsumerOneMessage() throws Exception {
        this.getMockEndpoint("mock:error").expectedMinimumMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo;direct:foo");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDirectNoConsumerTwoMessages() throws Exception {
        this.getMockEndpoint("mock:error").expectedMinimumMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo");
        this.template.sendBodyAndHeader("direct:start", (Object)"Bye World", "foo", (Object)"direct:foo");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDirectNoConsumerOneMessageBar() throws Exception {
        this.getMockEndpoint("mock:error").expectedMinimumMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMinimumMessageCount(1);
        this.template.sendBodyAndHeader("direct:bar", (Object)"Hello World", "bar", (Object)"mock:foo;direct:foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((DirectComponent)RecipientListDirectNoConsumerIssueTest.this.context.getComponent("direct", DirectComponent.class)).setBlock(false);
                this.onException(Exception.class).handled(true).to("mock:error");
                ((RecipientListDefinition)this.from("direct:start").recipientList().header("foo")).delimiter(";");
                this.from("direct:bar").recipientList(";").header("bar");
            }
        };
    }
}

