/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ProxyHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxyReturnNullIssueTest
extends ContextTestSupport {
    @Test
    public void testEcho() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        Assertions.assertEquals((Object)"Hello World", (Object)service.echo("Hello World"));
    }

    @Test
    public void testEchoNull() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        Assertions.assertNull((Object)service.echo(null));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:echo").bean((Object)new MyEchoBean());
            }
        };
    }

    public static interface Echo {
        public String echo(String var1);
    }

    public static class MyEchoBean
    implements Echo {
        @Override
        public String echo(String text) {
            return text;
        }
    }
}

