/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class PropertiesAvailableEverywhereTest
extends ContextTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext camelContext = super.createCamelContext();
        Properties properties = new Properties();
        properties.put("foo", "bar");
        camelContext.getRegistry().bind("myProp", (Object)properties);
        camelContext.getPropertiesComponent().addLocation("ref:myProp");
        return camelContext;
    }

    @Test
    public void testPropertiesInPredicates() throws Exception {
        this.getMockEndpoint("mock:header-ok").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:choice-ok").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:direct-ok").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:ko").expectedMessageCount(0);
        this.template.sendBody("direct:header-start", (Object)"Hello Camel");
        this.template.sendBody("direct:choice-start", (Object)"Hello Camel");
        this.template.sendBody("direct:direct-start", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((RouteDefinition)this.from("direct:header-start").setHeader("foo", (Expression)this.simple("{{foo}}"))).choice().when((Predicate)this.simple("${header.foo} == 'bar'")).to("mock:header-ok")).otherwise().to("mock:ko");
                ((ChoiceDefinition)this.from("direct:choice-start").choice().when((Predicate)this.simple("'{{foo}}' == 'bar'")).to("mock:choice-ok")).otherwise().to("mock:ko");
                this.from("direct:direct-start").to("direct:direct-{{foo}}");
                this.from("direct:direct-bar").to("mock:direct-ok");
            }
        };
    }
}

