/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PopulateInitialHeadersFailedIssueTest
extends ContextTestSupport {
    @Test
    public void testPopulateInitialHeadersFailed() throws Exception {
        DefaultExchange exchange = DefaultExchange.newFromEndpoint((Endpoint)this.context.getEndpoint("seda:start"));
        exchange.setPattern(ExchangePattern.InOut);
        MyFaultMessage msg = new MyFaultMessage((Exchange)exchange);
        exchange.setMessage((Message)msg);
        msg.setBody("Hello World");
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.send("seda:start", (Exchange)exchange);
        this.assertMockEndpointsSatisfied();
        IllegalArgumentException iae = PopulateInitialHeadersFailedIssueTest.assertIsInstanceOf(IllegalArgumentException.class, exchange.getException());
        Assertions.assertEquals((Object)"Forced headers error", (Object)iae.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(0L));
                this.from("seda:start").to("mock:result");
            }
        };
    }

    private static class MyFaultMessage
    extends DefaultMessage {
        public MyFaultMessage(Exchange exchange) {
            super(exchange);
        }

        protected void populateInitialHeaders(Map<String, Object> map) {
            throw new IllegalArgumentException("Forced headers error");
        }
    }
}

