/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionProcessIssueTest
extends ContextTestSupport {
    @Test
    public void testOnExceptionProcessIssue() {
        Exchange out = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"bar", (Object)out.getIn().getHeader("foo"));
        Assertions.assertEquals((Object)"ERROR: Damn for message: Hello World", (Object)out.getIn().getBody());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Exception.class).useOriginalMessage().handled(true).setHeader("foo", (Expression)this.constant("bar"))).process(new Processor(){

                    public void process(Exchange exchange) {
                        Message in = exchange.getIn();
                        Exception ex = (Exception)exchange.getProperty("CamelExceptionCaught", Exception.class);
                        in.setBody((Object)("ERROR: " + ex.getMessage() + " for message: " + String.valueOf(in.getBody())));
                    }
                });
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.constant("Bye World"))).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

