/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnExceptionErrorHandlerNoRouteOnExchangeIssueTest
extends ContextTestSupport {
    @Test
    public void testOk() {
        String out = (String)this.template.requestBody("direct:hello", null, String.class);
        Assertions.assertEquals((Object)"Hello World", (Object)out);
    }

    @Test
    public void testNormalError() {
        String out = (String)this.template.requestBody("direct:normalError", null, String.class);
        Assertions.assertEquals((Object)"general exception was properly handled", (Object)out);
    }

    @Test
    public void testBug() {
        String out = (String)this.template.requestBody("direct:bug", null, String.class);
        Assertions.assertEquals((Object)"general exception was properly handled", (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)((OnExceptionDefinition)this.onException(Exception.class).handled(true).log(LoggingLevel.ERROR, "error", "${messageHistory} \n ${exchange} \n ${exception.stacktrace}")).transform().simple("general exception was properly handled")).stop();
                ((ProcessorDefinition)this.from("direct:hello").routeId("routeHello").transform().constant((Object)"Hello World")).setHeader("CamelHttpResponseCode", (Expression)this.constant(200));
                ((RouteDefinition)this.from("direct:normalError").routeId("normalError").throwException((Exception)new NullPointerException("some null value"))).to("direct:hello");
                ((RouteDefinition)((RouteDefinition)this.from("direct:bug").routeId("routeBug").to("direct:detour")).throwException((Exception)new NullPointerException("something went wrong"))).to("direct:hello");
                this.from("direct:detour").routeId("routeDetour1").to("direct:detour2");
                this.from("direct:detour2").routeId("routeDetour2").transform().constant((Object)"random processing (should not be exposed)");
            }
        };
    }
}

