/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class OnExceptionBeforeErrorHandlerIssueTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        this.context.getRouteController().startRoute("foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testKaboom() throws Exception {
        this.context.getRouteController().startRoute("foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"kaboom");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testIllegal() throws Exception {
        this.context.getRouteController().startRoute("foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"illegal");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((ProcessorDefinition)this.onException(IllegalArgumentException.class).handled(true).setBody().constant((Object)"Handled")).to("mock:error")).end();
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead").useOriginalMessage());
                ((RouteDefinition)this.from("direct:start").routeId("foo").autoStartup(false).process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("illegal".equals(body)) {
                            throw new IllegalArgumentException("I cannot do this");
                        }
                        if ("kaboom".equals(body)) {
                            throw new RuntimeException("Kaboom");
                        }
                    }
                })).to("mock:result");
            }
        };
    }
}

