/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OnCompletionIssueTest
extends ContextTestSupport {
    @Test
    public void testOnCompletionIssue() throws Exception {
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        MockEndpoint complete = this.getMockEndpoint("mock:complete");
        complete.expectedBodiesReceivedInAnyOrder(new Object[]{"finish", "stop", "ile", "markRollback"});
        MockEndpoint failed = this.getMockEndpoint("mock:failed");
        failed.expectedBodiesReceivedInAnyOrder(new Object[]{"npe", "rollback"});
        this.template.sendBody("direct:input", (Object)"finish");
        this.template.sendBody("direct:input", (Object)"stop");
        this.template.sendBody("direct:input", (Object)"ile");
        this.template.sendBody("direct:input", (Object)"markRollback");
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:input", (Object)"npe"), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"Darn NPE", (Object)e.getCause().getMessage());
        CamelExecutionException ex = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:input", (Object)"rollback"), (String)"Should have thrown exception");
        OnCompletionIssueTest.assertIsInstanceOf(RollbackExchangeException.class, ex.getCause());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)this.onCompletion().onFailureOnly().parallelProcessing().log("failing ${body}")).to("mock:failed");
                ((OnCompletionDefinition)this.onCompletion().onCompleteOnly().parallelProcessing().log("completing ${body}")).to("mock:complete");
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:input").onException(IllegalArgumentException.class).handled(true).end().choice().when((Predicate)this.simple("${body} == 'stop'")).log("stopping")).stop()).when((Predicate)this.simple("${body} == 'ile'")).log("excepting")).throwException((Exception)new IllegalArgumentException("Exception requested"))).when((Predicate)this.simple("${body} == 'npe'")).log("excepting")).throwException((Exception)new NullPointerException("Darn NPE"))).when((Predicate)this.simple("${body} == 'rollback'")).log("rollback")).rollback()).when((Predicate)this.simple("${body} == 'markRollback'")).log("markRollback")).markRollbackOnly()).end().log("finishing").to("mock:end");
            }
        };
    }
}

