/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MulticastShareUnitOfWorkOnExceptionHandledFalseIssueTest
extends ContextTestSupport {
    @Test
    public void testMulticast() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should throw exception");
        IllegalArgumentException cause = MulticastShareUnitOfWorkOnExceptionHandledFalseIssueTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause().getCause());
        Assertions.assertEquals((Object)"Forced", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(false).to("mock:a");
                ((MulticastDefinition)this.from("direct:start").multicast().shareUnitOfWork().stopOnException().to("direct:b")).end().to("mock:result");
                ((RouteDefinition)this.from("direct:b").to("mock:b")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

