/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PipelineDefinition;
import org.junit.jupiter.api.Test;

public class MulticastPipelineAggregateIssueTest
extends ContextTestSupport {
    @Test
    public void testMulticastPipelineAggregateIssue() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{8});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{8});
        this.getMockEndpoint("mock:c").expectedBodiesReceived(new Object[]{8});
        this.template.sendBody("direct:a", (Object)1);
        this.template.sendBody("direct:b", (Object)1);
        this.template.sendBody("direct:c", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)this.from("direct:a").multicast((AggregationStrategy)new SumAggregateBean()).pipeline().bean(IncreaseOne.class)).bean((Object)new IncreaseTwo())).end().pipeline().bean(IncreaseOne.class)).bean((Object)new IncreaseTwo())).end().end().to("mock:a");
                ((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)this.from("direct:b").multicast((AggregationStrategy)new SumAggregateBean()).pipeline().transform((Expression)this.method(IncreaseOne.class))).bean((Object)new IncreaseTwo())).end().pipeline().transform((Expression)this.method(IncreaseOne.class))).bean((Object)new IncreaseTwo())).end().end().to("mock:b");
                ((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)this.from("direct:c").multicast((AggregationStrategy)new SumAggregateBean()).pipeline().transform((Expression)this.method(IncreaseOne.class))).transform((Expression)this.method(new IncreaseTwo()))).end().pipeline().transform((Expression)this.method(IncreaseOne.class))).transform((Expression)this.method(new IncreaseTwo()))).end().end().to("mock:c");
            }
        };
    }

    public static class SumAggregateBean
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            int num1 = (Integer)oldExchange.getIn().getBody(Integer.TYPE);
            int num2 = (Integer)newExchange.getIn().getBody(Integer.TYPE);
            newExchange.getIn().setBody((Object)(num1 + num2));
            return newExchange;
        }
    }

    public static class IncreaseTwo {
        public int addTwo(int num) {
            return num + 2;
        }
    }

    public static class IncreaseOne {
        public int addOne(int num) {
            return num + 1;
        }
    }
}

