/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MockValueBuilderIssueTest
extends ContextTestSupport {
    @Test
    public void testMockValueBuilder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).exchangeProperty("foo")).convertTo(String.class).contains((Object)"2");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMockValueBuilderFail() {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).exchangeProperty("foo")).convertTo(String.class).contains((Object)"4");
        this.template.sendBody("direct:start", (Object)"Hello World");
        Throwable e = Assertions.assertThrows(Throwable.class, () -> this.assertMockEndpointsSatisfied(), (String)"Should fail");
        String s = "Assertion error at index 0 on mock mock://result with predicate: exchangeProperty(foo) contains 4 evaluated as: 123 contains 4";
        Assertions.assertTrue((boolean)e.getMessage().startsWith(s));
    }

    @Test
    public void testMockValueBuilderNotSatisfied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).exchangeProperty("foo")).convertTo(String.class).contains((Object)"4");
        this.template.sendBody("direct:start", (Object)"Hello World");
        mock.assertIsNotSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setProperty("foo", (Expression)this.constant(123))).to("mock:result");
            }
        };
    }
}

