/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class MockExpectedHeadersIssueTest
extends ContextTestSupport {
    @Test
    public void testHeaders() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedHeaderReceived("header2", (Object)"value2");
        resultEndpoint.expectedHeaderReceived("header1", (Object)"value1");
        this.template.sendBody("direct:test", null);
        resultEndpoint.assertIsNotSatisfied();
    }

    @Test
    public void testHeadersAdded() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        ((MockValueBuilder)resultEndpoint.message(0).header("header1")).isNull();
        ((MockValueBuilder)resultEndpoint.message(0).header("header2")).isEqualTo((Object)"value2");
        this.template.sendBody("direct:test", null);
        resultEndpoint.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:test").setHeader("header2", (Expression)this.constant("value2"))).to("mock:result");
            }
        };
    }
}

