/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.support.builder.PredicateBuilder;
import org.junit.jupiter.api.Test;

public class MockExpectedHeaderXPathTest
extends ContextTestSupport {
    protected String filter = "/person[@name='James']";
    protected String name = "/person/@name";
    protected String matchingBody = "<person name='James' city='London'/>";
    protected String notMatchingBody = "<person name='Hiram' city='Tampa'/>";
    protected String notMatchingBody2 = "<person name='Jack' city='Houston'/>";

    @Test
    public void testHeaderXPathBuilderLanguageBuilder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        XPathExpression xpath = ((XPathExpression.Builder)this.expression().xpath(this.filter).source("header:cheese")).end();
        mock.message(0).predicate(PredicateBuilder.not((Predicate)xpath));
        mock.message(1).predicate((Predicate)xpath);
        mock.message(2).predicate(PredicateBuilder.not((Predicate)xpath));
        this.template.sendBodyAndHeader("direct:test", (Object)"message 1", "cheese", (Object)this.notMatchingBody);
        this.template.sendBodyAndHeader("direct:test", (Object)"message 2", "cheese", (Object)this.matchingBody);
        this.template.sendBodyAndHeader("direct:test", (Object)"message 3", "cheese", (Object)this.notMatchingBody2);
        mock.assertIsSatisfied();
    }

    @Test
    public void testHeaderXPathPredicate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        ((MockValueBuilder)mock.message(0).header("cheese")).xpath(this.filter).isFalse();
        ((MockValueBuilder)mock.message(1).header("cheese")).xpath(this.filter).isTrue();
        ((MockValueBuilder)mock.message(2).header("cheese")).xpath(this.filter).isFalse();
        this.template.sendBodyAndHeader("direct:test", (Object)"message 1", "cheese", (Object)this.notMatchingBody);
        this.template.sendBodyAndHeader("direct:test", (Object)"message 2", "cheese", (Object)this.matchingBody);
        this.template.sendBodyAndHeader("direct:test", (Object)"message 3", "cheese", (Object)this.notMatchingBody2);
        mock.assertIsSatisfied();
    }

    @Test
    public void testHeaderXPathExpressionAttribute() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(3);
        ((MockValueBuilder)mock.message(0).header("cheese")).xpath(this.name).isEqualTo((Object)"Hiram");
        ((MockValueBuilder)mock.message(1).header("cheese")).xpath(this.name).isEqualTo((Object)"James");
        ((MockValueBuilder)mock.message(2).header("cheese")).xpath(this.name).isEqualTo((Object)"Jack");
        this.template.sendBodyAndHeader("direct:test", (Object)"message 1", "cheese", (Object)this.notMatchingBody);
        this.template.sendBodyAndHeader("direct:test", (Object)"message 2", "cheese", (Object)this.matchingBody);
        this.template.sendBodyAndHeader("direct:test", (Object)"message 3", "cheese", (Object)this.notMatchingBody2);
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:test").to("mock:result");
            }
        };
    }
}

