/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Test;

public class MockExpectedHeaderSimpleTest
extends ContextTestSupport {
    @Test
    public void testSimple() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).simple("${header.num}")).isEqualTo((Object)3);
        ((MockValueBuilder)mock.message(0).simple("${header.num}")).isLessThan((Object)5);
        ((MockValueBuilder)mock.message(1).simple("${header.num}")).isEqualTo((Object)7);
        ((MockValueBuilder)mock.message(1).simple("${header.num}")).isGreaterThan((Object)5);
        this.template.sendBodyAndHeader("direct:test", (Object)"message 1", "num", (Object)"3");
        this.template.sendBodyAndHeader("direct:test", (Object)"message 2", "num", (Object)"7");
        mock.assertIsSatisfied();
    }

    @Test
    public void testHeaderSimple() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).header("num")).simple("${body}${body}").isEqualTo((Object)"33");
        ((MockValueBuilder)mock.message(1).header("num")).simple("${body}${body}").isEqualTo((Object)"77");
        this.template.sendBodyAndHeader("direct:test", (Object)"message 1", "num", (Object)"3");
        this.template.sendBodyAndHeader("direct:test", (Object)"message 2", "num", (Object)"7");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:test").to("mock:result");
            }
        };
    }
}

