/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class Issue170Test
extends ContextTestSupport {
    protected final String qOne = "seda:Q1";
    protected final String qTwo = "mock:Q2";
    protected final String qThree = "mock:Q3";

    @Test
    public void testSendMessagesGetCorrectCounts() throws Exception {
        MockEndpoint q2 = this.getMockEndpoint("mock:Q2");
        MockEndpoint q3 = this.getMockEndpoint("mock:Q3");
        String body1 = "<message id='1'/>";
        String body2 = "<message id='2'/>";
        q2.expectedBodiesReceived(new Object[]{body1, body2});
        q3.expectedBodiesReceived(new Object[]{body1, body2});
        this.template.sendBodyAndHeader("direct:start", (Object)body1, "counter", (Object)1);
        this.template.sendBodyAndHeader("direct:start", (Object)body2, "counter", (Object)2);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("seda:Q1");
                this.from("seda:Q1").to(new String[]{"mock:Q2", "mock:Q3"});
            }
        };
    }
}

