/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.InterceptDefinition;
import org.junit.jupiter.api.Test;

public class InterceptFromPredicateProceedAndStopTest
extends ContextTestSupport {
    @Test
    public void testInterceptorNoPredicate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptFrom().to("mock:test");
                this.from("seda:order").to("mock:ok");
            }
        });
        MockEndpoint mockTest = this.getMockEndpoint("mock:test");
        mockTest.expectedBodiesReceived(new Object[]{"Camel in Action"});
        MockEndpoint mockOk = this.getMockEndpoint("mock:ok");
        mockOk.expectedBodiesReceived(new Object[]{"Camel in Action"});
        this.template.sendBodyAndHeader("seda:order", (Object)"Camel in Action", "user", (Object)"test");
        mockTest.assertIsSatisfied();
        mockOk.assertIsSatisfied();
    }

    @Test
    public void testInterceptorNoPredicateAndProceed() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptFrom().to("mock:test");
                this.from("seda:order").to("mock:ok");
            }
        });
        MockEndpoint mockTest = this.getMockEndpoint("mock:test");
        mockTest.expectedBodiesReceived(new Object[]{"Camel in Action"});
        MockEndpoint mockOk = this.getMockEndpoint("mock:ok");
        mockOk.expectedBodiesReceived(new Object[]{"Camel in Action"});
        this.template.sendBodyAndHeader("seda:order", (Object)"Camel in Action", "user", (Object)"test");
        mockTest.assertIsSatisfied();
        mockOk.assertIsSatisfied();
    }

    @Test
    public void testInterceptorNoPredicateAndStop() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((InterceptDefinition)this.interceptFrom().to("mock:test")).stop();
                this.from("seda:order").to("mock:ok");
            }
        });
        MockEndpoint mockTest = this.getMockEndpoint("mock:test");
        mockTest.expectedBodiesReceived(new Object[]{"Camel in Action"});
        MockEndpoint mockOk = this.getMockEndpoint("mock:ok");
        mockOk.expectedMessageCount(0);
        this.template.sendBodyAndHeader("seda:order", (Object)"Camel in Action", "user", (Object)"test");
        mockTest.assertIsSatisfied();
        mockOk.assertIsSatisfied();
    }

    @Test
    public void testInterceptorWithPredicate() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptFrom().onWhen(this.header("user").isEqualTo((Object)"test")).to("mock:test");
                this.from("seda:order").to("mock:ok");
            }
        });
        MockEndpoint mockTest = this.getMockEndpoint("mock:test");
        mockTest.expectedBodiesReceived(new Object[]{"Camel in Action"});
        MockEndpoint mockOk = this.getMockEndpoint("mock:ok");
        mockOk.expectedBodiesReceived(new Object[]{"Camel in Action"});
        this.template.sendBodyAndHeader("seda:order", (Object)"Camel in Action", "user", (Object)"test");
        mockTest.assertIsSatisfied();
        mockOk.assertIsSatisfied();
    }

    @Test
    public void testInterceptorWithPredicateAndProceed() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.interceptFrom().onWhen(this.header("user").isEqualTo((Object)"test")).to("mock:test");
                this.from("seda:order").to("mock:ok");
            }
        });
        MockEndpoint mockTest = this.getMockEndpoint("mock:test");
        mockTest.expectedBodiesReceived(new Object[]{"Camel in Action"});
        MockEndpoint mockOk = this.getMockEndpoint("mock:ok");
        mockOk.expectedBodiesReceived(new Object[]{"Camel in Action"});
        this.template.sendBodyAndHeader("seda:order", (Object)"Camel in Action", "user", (Object)"test");
        mockTest.assertIsSatisfied();
        mockOk.assertIsSatisfied();
    }

    @Test
    public void testInterceptorWithPredicateAndStop() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((InterceptDefinition)this.interceptFrom().onWhen(this.header("user").isEqualTo((Object)"test")).to("mock:test")).stop();
                this.from("seda:order").to("mock:ok");
            }
        });
        MockEndpoint mockTest = this.getMockEndpoint("mock:test");
        mockTest.expectedBodiesReceived(new Object[]{"Camel in Action"});
        MockEndpoint mockOk = this.getMockEndpoint("mock:ok");
        mockOk.expectedMessageCount(0);
        this.template.sendBodyAndHeader("seda:order", (Object)"Camel in Action", "user", (Object)"test");
        mockTest.assertIsSatisfied();
        mockOk.assertIsSatisfied();
    }
}

