/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GertJBIIssueTest
extends ContextTestSupport {
    private static Exception cause;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testSimulateJBIEndpointFail() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dlc").maximumRedeliveries(0));
                ((ThreadsDefinition)this.from("direct:start").threads(2).to("mock:done")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:done").expectedMessageCount(1);
        this.getMockEndpoint("mock:dlc").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSimulateJBIEndpointNotExistOnCompletion() throws Exception {
        cause = null;
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ThreadsDefinition)this.from("direct:start").threads(2).to("mock:done")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:done").expectedMessageCount(1);
        final CountDownLatch latch = new CountDownLatch(1);
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                    public void onDone(Exchange exchange) {
                        cause = exchange.getException();
                        latch.countDown();
                    }
                });
            }
        });
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        Assertions.assertNotNull((Object)cause, (String)"Should have failed");
        GertJBIIssueTest.assertIsInstanceOf(IllegalArgumentException.class, cause);
        Assertions.assertEquals((Object)"Forced", (Object)cause.getMessage());
    }
}

