/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.junit.jupiter.api.Test;

public class FileSplitStreamingWithChoiceTest
extends ContextTestSupport {
    @Test
    public void testSplitStreamingWithChoice() throws Exception {
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:body");
        mock.expectedBodiesReceived(new Object[]{"line1", "line2", "line3"});
        mock.expectedFileExists(this.testFile(".camel/splitme.txt"));
        String body = "line1" + LS + "line2" + LS + "line3";
        this.template.sendBodyAndHeader(this.fileUri(), (Object)body, "CamelFileName", (Object)"splitme.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ExpressionNode)this.from(FileSplitStreamingWithChoiceTest.this.fileUri("?initialDelay=0&delay=10")).split((Expression)this.body().tokenize(LS)).streaming().to("mock:split")).choice().when(this.bodyAs(String.class).isNotNull()).to("mock:body")).otherwise().to("mock:other")).end();
            }
        };
    }
}

