/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilePollingConsumerIssueTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testFilePollingConsumer() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        Endpoint endpoint = this.context.getEndpoint(this.fileUri("?initialDelay=0&delay=10&fileName=" + TEST_FILE_NAME));
        PollingConsumer consumer = endpoint.createPollingConsumer();
        consumer.start();
        Exchange exchange = consumer.receive(5000L);
        Assertions.assertNotNull((Object)exchange);
        Assertions.assertEquals((Object)TEST_FILE_NAME, (Object)exchange.getIn().getHeader("CamelFileName", String.class));
        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody(String.class));
        consumer.stop();
    }
}

