/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="TODO: fix me")
public class ExceptionThrownFromOnExceptionTest
extends ContextTestSupport {
    private static final AtomicInteger RETRY = new AtomicInteger();
    private static final AtomicInteger ON_EXCEPTION_RETRY = new AtomicInteger();

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testExceptionThrownFromOnException() throws Exception {
        RETRY.set(0);
        ON_EXCEPTION_RETRY.set(0);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IOException.class).redeliveryDelay(0L).maximumRedeliveries(3).to("mock:b")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ON_EXCEPTION_RETRY.incrementAndGet();
                        throw new IOException("Some other IOException");
                    }
                })).to("mock:c");
                ((RouteDefinition)this.from("direct:start").to("direct:intermediate")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        RETRY.incrementAndGet();
                        throw new IOException("IO error");
                    }
                })).to("mock:end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should have thrown an exception");
        IOException cause = ExceptionThrownFromOnExceptionTest.assertIsInstanceOf(IOException.class, e.getCause());
        Assertions.assertEquals((Object)"Some other IOException", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)RETRY.get(), (String)"Should try 4 times (1 first, 3 retry)");
        Assertions.assertEquals((int)1, (int)ON_EXCEPTION_RETRY.get(), (String)"Should only invoke onException once");
    }

    @Test
    public void testExceptionThrownFromOnExceptionAndHandled() throws Exception {
        RETRY.set(0);
        ON_EXCEPTION_RETRY.set(0);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IOException.class).redeliveryDelay(0L).maximumRedeliveries(3).handled(true).to("mock:b")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ON_EXCEPTION_RETRY.incrementAndGet();
                        throw new IOException("Some other IOException");
                    }
                })).to("mock:c");
                ((RouteDefinition)this.from("direct:start").to("direct:intermediate")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        RETRY.incrementAndGet();
                        throw new IOException("IO error");
                    }
                })).to("mock:end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should have thrown an exception");
        IOException cause = ExceptionThrownFromOnExceptionTest.assertIsInstanceOf(IOException.class, e.getCause());
        Assertions.assertEquals((Object)"Some other IOException", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)RETRY.get(), (String)"Should try 4 times (1 first, 3 retry)");
        Assertions.assertEquals((int)1, (int)ON_EXCEPTION_RETRY.get(), (String)"Should only invoke onException once");
    }

    @Test
    public void testExceptionThrownFromOnExceptionWithDeadLetterChannel() throws Exception {
        RETRY.set(0);
        ON_EXCEPTION_RETRY.set(0);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3);
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IOException.class).redeliveryDelay(0L).maximumRedeliveries(3).to("mock:b")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ON_EXCEPTION_RETRY.incrementAndGet();
                        throw new IOException("Some other IOException");
                    }
                })).to("mock:c");
                ((RouteDefinition)this.from("direct:start").to("direct:intermediate")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        RETRY.incrementAndGet();
                        throw new IOException("IO error");
                    }
                })).to("mock:end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should have thrown an exception");
        IOException cause = ExceptionThrownFromOnExceptionTest.assertIsInstanceOf(IOException.class, e.getCause());
        Assertions.assertEquals((Object)"Some other IOException", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)RETRY.get(), (String)"Should try 4 times (1 first, 3 retry)");
        Assertions.assertEquals((int)1, (int)ON_EXCEPTION_RETRY.get(), (String)"Should only invoke onException once");
    }

    @Test
    public void testExceptionThrownFromOnExceptionAndHandledWithDeadLetterChannel() throws Exception {
        RETRY.set(0);
        ON_EXCEPTION_RETRY.set(0);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3);
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IOException.class).redeliveryDelay(0L).maximumRedeliveries(3).handled(true).to("mock:b")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        ON_EXCEPTION_RETRY.incrementAndGet();
                        throw new IOException("Some other IOException");
                    }
                })).to("mock:c");
                ((RouteDefinition)this.from("direct:start").to("direct:intermediate")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        RETRY.incrementAndGet();
                        throw new IOException("IO error");
                    }
                })).to("mock:end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should have thrown an exception");
        IOException cause = ExceptionThrownFromOnExceptionTest.assertIsInstanceOf(IOException.class, e.getCause());
        Assertions.assertEquals((Object)"Some other IOException", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)RETRY.get(), (String)"Should try 4 times (1 first, 3 retry)");
        Assertions.assertEquals((int)1, (int)ON_EXCEPTION_RETRY.get(), (String)"Should only invoke onException once");
    }

    @Test
    public void testNoExceptionThrownFromOnExceptionWithDeadLetterChannel() throws Exception {
        RETRY.set(0);
        ON_EXCEPTION_RETRY.set(0);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3);
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IOException.class).redeliveryDelay(0L).maximumRedeliveries(3).to("mock:b")).process(new Processor(){

                    public void process(Exchange exchange) {
                        ON_EXCEPTION_RETRY.incrementAndGet();
                    }
                })).to("mock:c");
                ((RouteDefinition)this.from("direct:start").to("direct:intermediate")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        RETRY.incrementAndGet();
                        throw new IOException("IO error");
                    }
                })).to("mock:end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should have thrown an exception");
        IOException cause = ExceptionThrownFromOnExceptionTest.assertIsInstanceOf(IOException.class, e.getCause());
        Assertions.assertEquals((Object)"IO error", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)RETRY.get(), (String)"Should try 4 times (1 first, 3 retry)");
        Assertions.assertEquals((int)1, (int)ON_EXCEPTION_RETRY.get(), (String)"Should only invoke onException once");
    }

    @Test
    public void testNoExceptionThrownFromOnExceptionAndHandledWithDeadLetterChannel() throws Exception {
        RETRY.set(0);
        ON_EXCEPTION_RETRY.set(0);
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3);
                ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IOException.class).redeliveryDelay(0L).maximumRedeliveries(3).handled(true).to("mock:b")).process(new Processor(){

                    public void process(Exchange exchange) {
                        ON_EXCEPTION_RETRY.incrementAndGet();
                    }
                })).to("mock:c");
                ((RouteDefinition)this.from("direct:start").to("direct:intermediate")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        RETRY.incrementAndGet();
                        throw new IOException("IO error");
                    }
                })).to("mock:end");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)RETRY.get(), (String)"Should try 4 times (1 first, 3 retry)");
        Assertions.assertEquals((int)1, (int)ON_EXCEPTION_RETRY.get(), (String)"Should only invoke onException once");
    }
}

