/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExceptionTest
extends ContextTestSupport {
    @Test
    public void testExceptionWithoutHandler() throws Exception {
        MockEndpoint errorEndpoint = this.getMockEndpoint("mock:error");
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MockEndpoint exceptionEndpoint = this.getMockEndpoint("mock:exception");
        errorEndpoint.expectedBodiesReceived(new Object[]{"<exception/>"});
        exceptionEndpoint.expectedMessageCount(0);
        resultEndpoint.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"<body/>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExceptionWithHandler() throws Exception {
        MockEndpoint errorEndpoint = this.getMockEndpoint("mock:error");
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MockEndpoint exceptionEndpoint = this.getMockEndpoint("mock:exception");
        errorEndpoint.expectedMessageCount(0);
        exceptionEndpoint.expectedBodiesReceived(new Object[]{"<exception/>"});
        resultEndpoint.expectedMessageCount(0);
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"<body/>"), (String)"Should have thrown exception");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExceptionWithLongHandler() throws Exception {
        MockEndpoint errorEndpoint = this.getMockEndpoint("mock:error");
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MockEndpoint exceptionEndpoint = this.getMockEndpoint("mock:exception");
        errorEndpoint.expectedMessageCount(0);
        exceptionEndpoint.expectedBodiesReceived(new Object[]{"<not-handled/>"});
        resultEndpoint.expectedMessageCount(0);
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"<body/>"), (String)"Should have thrown exception");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testLongRouteWithHandler() throws Exception {
        MockEndpoint errorEndpoint = this.getMockEndpoint("mock:error");
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        MockEndpoint exceptionEndpoint = this.getMockEndpoint("mock:exception");
        errorEndpoint.expectedMessageCount(0);
        exceptionEndpoint.expectedBodiesReceived(new Object[]{"<exception/>"});
        resultEndpoint.expectedMessageCount(0);
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start2", (Object)"<body/>"), (String)"Should have thrown exception");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        final Processor exceptionThrower = exchange -> {
            exchange.getIn().setBody((Object)"<exception/>");
            throw new IllegalArgumentException("Exception thrown intentionally.");
        };
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").redeliveryDelay(0L).maximumRedeliveries(3));
                if (ExceptionTest.this.getName().endsWith("WithLongHandler")) {
                    this.log.debug("Using long exception handler");
                    ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).setBody((Expression)this.constant("<not-handled/>"))).to("mock:exception");
                } else if (ExceptionTest.this.getName().endsWith("WithHandler")) {
                    this.log.debug("Using exception handler");
                    this.onException(IllegalArgumentException.class).to("mock:exception");
                }
                ((RouteDefinition)this.from("direct:start").process(exceptionThrower)).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").to("direct:intermediate")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").setBody((Expression)this.constant("<some-value/>"))).process(exceptionThrower)).to("mock:result");
            }
        };
    }
}

