/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class ExceptionPolicyIssueTest
extends ContextTestSupport {
    @Test
    public void testOnExceptionWithGenericException() throws Exception {
        this.getMockEndpoint("mock:exception").expectedMessageCount(0);
        this.getMockEndpoint("mock:ue").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(MyUnmarshalException.class).handled(true).to("mock:ue");
                this.onException(Exception.class).handled(true).to("mock:exception");
                this.from("direct:start").throwException((Exception)new MyUnmarshalException("Could not unmarshal", new IllegalArgumentException("Damn")));
            }
        };
    }

    private static final class MyUnmarshalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private MyUnmarshalException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

