/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExceptionCamel4022Test
extends ContextTestSupport {
    @Test
    public void testExceptionWithFatalException() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:intermediate").expectedMessageCount(0);
        this.getMockEndpoint("mock:onexception").expectedMessageCount(0);
        this.getMockEndpoint("mock:dlc").expectedMessageCount(0);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"<body/>"), (String)"Should throw an exception");
        IllegalArgumentException cause = ExceptionCamel4022Test.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Damn Again", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dlc").redeliveryDelay(0L).maximumRedeliveries(3));
                ((OnExceptionDefinition)this.onException(Exception.class).logStackTrace(false).process((Processor)new MyExceptionThrower("Damn Again"))).to("mock:onexception");
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:a")).to("direct:intermediate")).to("mock:result2");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:intermediate").to("mock:b")).setBody((Expression)this.constant("<some-value/>"))).process((Processor)new MyExceptionThrower("Damn"))).to("mock:intermediate");
            }
        };
    }

    public static class MyExceptionThrower
    implements Processor {
        private final String msg;

        public MyExceptionThrower(String msg) {
            this.msg = msg;
        }

        public void process(Exchange exchange) {
            throw new IllegalArgumentException(this.msg);
        }
    }
}

