/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.ExpressionAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ErrorHandlerOnRedeliveryStopTest
extends ContextTestSupport {
    private final AtomicInteger counter = new AtomicInteger(5);

    @Test
    public void testRetryWhile() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should throw an exception");
        RejectedExecutionException ree = ErrorHandlerOnRedeliveryStopTest.assertIsInstanceOf(RejectedExecutionException.class, e.getCause());
        Assertions.assertEquals((Object)"I do not want to do this anymore", (Object)ree.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().retryWhile((Expression)new ExpressionAdapter(){

                    public Object evaluate(Exchange exchange) {
                        return ErrorHandlerOnRedeliveryStopTest.this.counter.getAndDecrement() > 0;
                    }
                }).onRedelivery((Processor)new MyRedeliveryProcessor()).redeliveryDelay(0L));
                ((RouteDefinition)this.from("direct:start").throwException((Exception)new IllegalArgumentException("Forced"))).to("mock:result");
            }
        };
    }

    private class MyRedeliveryProcessor
    implements Processor {
        private MyRedeliveryProcessor() {
        }

        public void process(Exchange exchange) {
            if (ErrorHandlerOnRedeliveryStopTest.this.counter.get() == 0) {
                exchange.setException((Throwable)new RejectedExecutionException("I do not want to do this anymore"));
                exchange.setRouteStop(true);
            }
        }
    }
}

