/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.List;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndpointWithRawUriParameterTest
extends ContextTestSupport {
    @Test
    public void testRawUriParameter() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("username", (Object)"scott");
        this.getMockEndpoint("mock:result").expectedHeaderReceived("password", (Object)"++%%w?rd)");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUriParameterLines() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:lines", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        List lines = (List)((Exchange)this.getMockEndpoint("mock:result").getReceivedExchanges().get(0)).getIn().getHeader("lines");
        Assertions.assertEquals((int)2, (int)lines.size());
        Assertions.assertEquals((Object)"abc", lines.get(0));
        Assertions.assertEquals((Object)"def", lines.get(1));
    }

    @Test
    public void testRawUriParameterLines() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:rawlines", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        List lines = (List)((Exchange)this.getMockEndpoint("mock:result").getReceivedExchanges().get(0)).getIn().getHeader("lines");
        Assertions.assertEquals((int)2, (int)lines.size());
        Assertions.assertEquals((Object)"++abc++", lines.get(0));
        Assertions.assertEquals((Object)"++def++", lines.get(1));
    }

    @Test
    public void testRawUriParameterPlusSign() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("username", (Object)"scott");
        this.getMockEndpoint("mock:result").expectedHeaderReceived("password", (Object)"foo)+bar");
        this.template.sendBody("direct:plus", (Object)"Hello World");
        this.getMockEndpoint("mock:result").assertIsNotSatisfied();
    }

    @Test
    public void testRawUriParameterOk() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("username", (Object)"scott");
        this.getMockEndpoint("mock:result").expectedHeaderReceived("password", (Object)"foo)+bar");
        this.template.sendBody("direct:ok", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRawUriParameterOkDynamic() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("username", (Object)"scott");
        this.getMockEndpoint("mock:result").expectedHeaderReceived("password", (Object)"foo)+bar");
        this.template.sendBody("direct:okDynamic", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                EndpointWithRawUriParameterTest.this.context.addComponent("mycomponent", (Component)new MyComponent());
                ((RouteDefinition)this.from("direct:start").to("mycomponent:foo?username=scott&password=RAW(++%%w?rd))")).to("mock:result");
                ((RouteDefinition)this.from("direct:lines").to("mycomponent:foo?lines=abc&lines=def")).to("mock:result");
                ((RouteDefinition)this.from("direct:rawlines").to("mycomponent:foo?lines=RAW(++abc++)&lines=RAW(++def++)")).to("mock:result");
                ((RouteDefinition)this.from("direct:plus").to("mycomponent:foo?password=foo)+bar&username=scott")).to("mock:result");
                ((RouteDefinition)this.from("direct:ok").to("mycomponent:foo?password=RAW(foo)+bar)&username=scott")).to("mock:result");
                ((RouteDefinition)this.from("direct:okDynamic").toD("mycomponent:foo?password=RAW{foo)+bar}&username=scott")).to("mock:result");
            }
        };
    }

    public static final class MyEndpoint
    extends DefaultEndpoint {
        private String username;
        private String password;
        private List<String> lines;

        public MyEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        public Producer createProducer() {
            return new DefaultProducer((Endpoint)this){

                public void process(Exchange exchange) {
                    exchange.getIn().setHeader("username", (Object)this.getUsername());
                    exchange.getIn().setHeader("password", (Object)this.getPassword());
                    exchange.getIn().setHeader("lines", this.getLines());
                }
            };
        }

        public Consumer createConsumer(Processor processor) {
            return null;
        }

        public boolean isSingleton() {
            return true;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public void setLines(List<String> lines) {
            this.lines = lines;
        }
    }

    public static final class MyComponent
    extends DefaultComponent {
        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            MyEndpoint answer = new MyEndpoint(uri, (Component)this);
            this.setProperties((Endpoint)answer, parameters);
            return answer;
        }
    }
}

