/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicallyConcurrentlyAddRoutesTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentlyAddRoutes() throws Exception {
        this.context.start();
        Supplier<Callable> addRouteSupplier = () -> {
            Callable<Boolean> addRouteTask = () -> {
                final String routeId = UUID.randomUUID().toString();
                this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                    public void configure() {
                        String endpointUri = "tmp:start_" + routeId;
                        MySlowEndpoint mySlowEndpoint = new MySlowEndpoint(endpointUri, (CamelContext)DynamicallyConcurrentlyAddRoutesTest.this.context);
                        ((RouteDefinition)this.from((Endpoint)mySlowEndpoint).id(routeId)).to("mock:result");
                        this.log.info("Route {} configured", (Object)endpointUri);
                    }
                });
                this.context.getRouteController().stopRoute(routeId, 30L, TimeUnit.SECONDS, true);
                boolean result = this.context.removeRoute(routeId);
                this.log.info("Tried to remove route {}. Success? {}", (Object)routeId, (Object)result);
                return result;
            };
            return addRouteTask;
        };
        List<Callable> tasks = Stream.generate(addRouteSupplier).limit(4L).toList();
        ExecutorService ex = Executors.newFixedThreadPool(4);
        try {
            List result = ex.invokeAll(tasks, 1L, TimeUnit.MINUTES);
            ex.awaitTermination(10L, TimeUnit.SECONDS);
            long failed = result.stream().filter(p -> {
                try {
                    return Boolean.FALSE.equals(p.get());
                }
                catch (Exception e) {
                    return false;
                }
            }).count();
            long successful = result.stream().filter(p -> {
                try {
                    return Boolean.TRUE.equals(p.get());
                }
                catch (Exception e) {
                    return false;
                }
            }).count();
            this.log.info("Success/Failed: {}/{}", (Object)successful, (Object)failed);
            Assertions.assertEquals((long)4L, (long)successful);
            Assertions.assertEquals((long)0L, (long)failed);
        }
        finally {
            ex.shutdown();
            this.context.stop();
        }
    }

    private static class MySlowEndpoint
    extends DefaultEndpoint {
        private static final Logger LOG = LoggerFactory.getLogger(MySlowEndpoint.class);

        public MySlowEndpoint(String endpointUri, CamelContext context) {
            super(endpointUri, null);
            this.setCamelContext(context);
        }

        public Consumer createConsumer(Processor processor) {
            LOG.info("Creating slow consumer");
            return new DefaultConsumer((Endpoint)this, processor){

                protected void doStart() throws Exception {
                    LOG.trace("Slow start.");
                    Thread.sleep(100L);
                    super.doStart();
                    LOG.trace("Slow start done.");
                }
            };
        }

        public Producer createProducer() {
            return null;
        }
    }
}

