/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Header;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRouterWithInterceptorTest
extends ContextTestSupport {
    private final MyInterceptStrategy interceptStrategy = new MyInterceptStrategy();

    @Test
    public void testDynamicRouterOne() throws Exception {
        this.interceptStrategy.reset();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)MyInterceptStrategy.doneCount, (String)"Done method shall be called only once");
    }

    @Test
    public void testDynamicRouterTwo() throws Exception {
        this.interceptStrategy.reset();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)1, (int)MyInterceptStrategy.doneCount, (String)"Done method shall be called only once");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                DynamicRouterWithInterceptorTest.this.context.getCamelContextExtension().addInterceptStrategy((InterceptStrategy)DynamicRouterWithInterceptorTest.this.interceptStrategy);
                this.from("direct:start").dynamicRouter((Expression)this.method(DynamicRouterWithInterceptorTest.class, "slip")).to("mock:result");
                ((RouteDefinition)this.from("direct:foo").to("log:foo")).to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").to("log:bar")).to("mock:bar");
            }
        };
    }

    public String slip(@Body String body, @Header(value="CamelSlipEndpoint") String previous) {
        if (previous == null) {
            return "direct:foo";
        }
        if ("Bye World".equals(body) && "direct://foo".equals(previous)) {
            return "direct:bar";
        }
        return null;
    }

    public static class MyInterceptStrategy
    implements InterceptStrategy {
        private static final Logger LOGGER = LoggerFactory.getLogger(MyInterceptStrategy.class);
        private static int doneCount;

        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) {
            if (definition instanceof DynamicRouterDefinition) {
                DelegateAsyncProcessor delegateAsyncProcessor = new DelegateAsyncProcessor(){

                    public boolean process(Exchange exchange, final AsyncCallback callback) {
                        LOGGER.info("I'm doing someting");
                        return super.process(exchange, new AsyncCallback(){

                            public void done(boolean doneSync) {
                                LOGGER.info("I'm done");
                                ++doneCount;
                                callback.done(doneSync);
                            }
                        });
                    }
                };
                delegateAsyncProcessor.setProcessor(target);
                return delegateAsyncProcessor;
            }
            return new DelegateAsyncProcessor(target);
        }

        public void reset() {
            doneCount = 0;
        }
    }
}

