/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DavidSiefertTest
extends ContextTestSupport {
    protected static final Object expectedBody = "Some Output";

    @Test
    public void testWorks() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(1);
        result.expectedBodiesReceived(new Object[]{expectedBody});
        ((MockValueBuilder)result.message(0).header("sample.name")).isEqualTo((Object)"myValue");
        this.template.sendBody("direct:start", (Object)"<sample><name>value</name></sample>");
        result.assertIsSatisfied();
    }

    @Test
    public void testHeaderPredicateFails() {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        ((MockValueBuilder)result.message(0).header("sample.name")).isEqualTo((Object)"shouldNotMatch");
        this.template.sendBody("direct:start", (Object)"<sample><name>value</name></sample>");
        AssertionError e = (AssertionError)((Object)Assertions.assertThrows(AssertionError.class, () -> ((MockEndpoint)result).assertIsSatisfied(), (String)"Should have failed this test!"));
        this.log.info("Caught expected assertion failure: {}", (Object)e, (Object)e);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            exchange.getIn().getBody(String.class);
            Message output = exchange.getMessage();
            output.setHeader("sample.name", (Object)"myValue");
            output.setBody(expectedBody);
        }
    }
}

