/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;

public class CustomFailveOverProcessor
extends ContextTestSupport {
    public void testFailOver() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Bye World", (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").process((Processor)new MyFailOverProcessor(CustomFailveOverProcessor.this.template, "direct:a", "direct:b"));
                ((RouteDefinition)this.from("direct:a").to("mock:a")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IOException("Forced");
                    }
                });
                ((RouteDefinition)this.from("direct:b").to("mock:b")).transform((Expression)this.constant("Bye World"));
            }
        };
    }

    private static class MyFailOverProcessor
    implements Processor {
        private final List<String> uris;
        private final ProducerTemplate template;

        MyFailOverProcessor(ProducerTemplate template, String ... uris) {
            this.template = template;
            this.uris = Arrays.asList(uris);
        }

        public void process(Exchange exchange) {
            for (String uri : this.uris) {
                exchange.setException(null);
                this.template.send(uri, exchange);
                if (exchange.getException() != null) continue;
                return;
            }
        }
    }
}

