/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.IOException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ContextScopedOnExceptionNotHandledRouteScopedErrorHandlerRefIssueTwoRoutesTest
extends ContextTestSupport {
    @Test
    public void testOnExceptionErrorHandlerRef() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        CamelExecutionException e = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:start", (Object)"Hello World"), (String)"Should have thrown exception");
        IllegalArgumentException cause = ContextScopedOnExceptionNotHandledRouteScopedErrorHandlerRefIssueTwoRoutesTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
        Assertions.assertEquals((Object)"Damn", (Object)cause.getMessage());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOnExceptionErrorHandlerRefFoo() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myDLC", (Object)new DeadLetterChannelBuilder("mock:dead"));
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(false).to("mock:handled")).end();
                ((RouteDefinition)this.from("direct:foo").errorHandler("myDLC").to("mock:foo")).throwException((Exception)new IOException("Damn IO"));
                ((RouteDefinition)this.from("direct:start").errorHandler("myDLC").to("mock:a")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

