/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.seda.SedaEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerTemplateSedaQueueIssueTest
extends ContextTestSupport {
    @Test
    public void testConsumerTemplateSedaQueue() {
        this.template.sendBody("direct:start", (Object)"A");
        this.template.sendBody("direct:start", (Object)"B");
        this.template.sendBody("direct:start", (Object)"C");
        this.template.sendBody("direct:start", (Object)"D");
        this.template.sendBody("direct:start", (Object)"E");
        SedaEndpoint seda = (SedaEndpoint)this.context.getEndpoint("seda:foo", SedaEndpoint.class);
        Assertions.assertEquals((int)5, (int)seda.getCurrentQueueSize());
        String body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        Assertions.assertEquals((Object)"A", (Object)body);
        Assertions.assertEquals((int)4, (int)seda.getCurrentQueueSize());
        body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        Assertions.assertEquals((Object)"B", (Object)body);
        Assertions.assertEquals((int)3, (int)seda.getCurrentQueueSize());
        body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        Assertions.assertEquals((Object)"C", (Object)body);
        Assertions.assertEquals((int)2, (int)seda.getCurrentQueueSize());
        body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        Assertions.assertEquals((Object)"D", (Object)body);
        Assertions.assertEquals((int)1, (int)seda.getCurrentQueueSize());
        body = (String)this.consumer.receiveBody((Endpoint)seda, 1000L, String.class);
        Assertions.assertEquals((Object)"E", (Object)body);
        Assertions.assertEquals((int)0, (int)seda.getCurrentQueueSize());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("seda:foo");
            }
        };
    }
}

