/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ComponentUseRawUriTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context.addComponent("my", (Component)new MyComponent());
    }

    @Test
    public void testUseRaw() {
        String uri = "my:host:11303/tube1+tube?foo=%2B+tube%3F&bar=++%%w?rd";
        MyEndpoint endpoint = (MyEndpoint)this.context.getEndpoint(uri, MyEndpoint.class);
        Assertions.assertNotNull((Object)((Object)endpoint), (String)"endpoint");
        Assertions.assertEquals((Object)"%2B+tube%3F", (Object)endpoint.getFoo());
        Assertions.assertEquals((Object)"++%%w?rd", (Object)endpoint.getBar());
        Assertions.assertEquals((Object)uri, (Object)endpoint.getUri());
    }

    static class MyComponent
    extends DefaultComponent {
        MyComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
            MyEndpoint answer = new MyEndpoint(uri, (Component)this, remaining);
            this.setProperties((Endpoint)answer, parameters);
            return answer;
        }

        public boolean useRawUri() {
            return true;
        }
    }

    public static class MyEndpoint
    extends DefaultEndpoint {
        final String remaining;
        String foo;
        String bar;

        public MyEndpoint(String uri, Component component, String remaining) {
            super(uri, component);
            this.remaining = remaining;
        }

        public Producer createProducer() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Consumer createConsumer(Processor processor) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }

        public boolean isSingleton() {
            return true;
        }

        public String getUri() {
            return this.getEndpointUri();
        }
    }
}

