/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeException;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharlesSplitUseBeanAsErrorHandlerIssueTest
extends ContextTestSupport {
    private static String logged;

    @Test
    public void testSplitBeanErrorHandlerOK() throws Exception {
        MockEndpoint split = this.getMockEndpoint("mock:split");
        MockEndpoint ile = this.getMockEndpoint("mock:ile");
        MockEndpoint exception = this.getMockEndpoint("mock:exception");
        split.expectedBodiesReceived(new Object[]{"A", "B", "C"});
        ile.expectedMessageCount(0);
        exception.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitBeanErrorHandlerHandled() throws Exception {
        MockEndpoint split = this.getMockEndpoint("mock:split");
        MockEndpoint ile = this.getMockEndpoint("mock:ile");
        MockEndpoint exception = this.getMockEndpoint("mock:exception");
        split.expectedBodiesReceived(new Object[]{"A", "B", "C"});
        ile.expectedBodiesReceived(new Object[]{"Handled Forced Cause by Damn ILE"});
        exception.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"A,B,Forced,C");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Forced", (Object)logged);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").split((Expression)this.body().tokenize(",")).stopOnException().doTry().process((Processor)new MyProcessor())).to("mock:split")).doCatch(IllegalArgumentException.class).bean((Object)new MyLoggerBean())).bean((Object)new MyErrorHandlerBean())).to("mock:ile")).doCatch(Exception.class).to("mock:exception")).rollback()).end();
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Forced".equals(body)) {
                throw new IllegalArgumentException("Damn ILE");
            }
            if ("Kaboom".equals(body)) {
                throw new Exception("Kaboom");
            }
        }
    }

    public static class MyErrorHandlerBean {
        public String handleError(String body, @ExchangeException Exception e) {
            return "Handled " + body + " Cause by " + e.getMessage();
        }
    }

    public static class MyLoggerBean {
        public void logError(String body) {
            logged = body;
        }
    }
}

