/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChangeHeaderCaseIssueTest
extends ContextTestSupport {
    @Test
    public void testChangeHeaderCaseIssue() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("SoapAction", (Object)"cool");
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "SOAPAction", (Object)"cool");
        this.assertMockEndpointsSatisfied();
        HashMap headers = new HashMap(((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeaders());
        Assertions.assertEquals((Object)"cool", headers.get("SoapAction"));
        Assertions.assertNull(headers.get("SOAPAction"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("mock:result").process(new Processor(){

                    public void process(Exchange exchange) {
                        Object value = exchange.getIn().removeHeader("SOAPAction");
                        exchange.getIn().setHeader("SoapAction", value);
                    }
                });
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

