/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.DefaultEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Camel4857UriIssueTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.context.addComponent("my", (Component)new MyComponent());
    }

    @Test
    public void testExclamationInUri() {
        MyEndpoint endpoint = (MyEndpoint)this.context.getEndpoint("my:host:11303/tube1+tube%2B+tube%3F", MyEndpoint.class);
        Assertions.assertNotNull((Object)((Object)endpoint), (String)"endpoint");
        Assertions.assertEquals((Object)"my:host:11303/tube1+tube%2B+tube%3F", (Object)endpoint.getUri());
    }

    @Test
    public void testPath() {
        MyEndpoint endpoint = (MyEndpoint)this.context.getEndpoint("my:host:11303/tube1+tube%2B", MyEndpoint.class);
        Assertions.assertEquals((Object)"host:11303/tube1+tube%2B", (Object)endpoint.remaining, (String)"Path contains several tube names, every tube name may have + or ? characters");
    }

    static class MyComponent
    extends DefaultComponent {
        MyComponent() {
        }

        protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) {
            return new MyEndpoint(uri, remaining);
        }

        public boolean useRawUri() {
            return true;
        }
    }

    static class MyEndpoint
    extends DefaultEndpoint {
        final String uri;
        final String remaining;

        MyEndpoint(String uri, String remaining) {
            this.uri = uri;
            this.remaining = remaining;
        }

        public Producer createProducer() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Consumer createConsumer(Processor processor) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isSingleton() {
            return true;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

