/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CBRCustomPredicateAsFilterTest
extends ContextTestSupport {
    private final MyFiler filter = new MyFiler();

    @Test
    public void testCBRCustomPredicateAsFilter() throws Exception {
        this.getMockEndpoint("mock:good").expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.getMockEndpoint("mock:secret").expectedBodiesReceived(new Object[]{"secret"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"secret");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((Object)"Hello World", (Object)this.filter.getBodies().get(0));
        Assertions.assertEquals((Object)"secret", (Object)this.filter.getBodies().get(1));
        Assertions.assertEquals((Object)"Bye World", (Object)this.filter.getBodies().get(2));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)this.from("direct:start").choice().when((Predicate)CBRCustomPredicateAsFilterTest.this.filter).to("mock:good")).otherwise().to("mock:secret");
            }
        };
    }

    private static class MyFiler
    implements Predicate {
        private final List<String> bodies = new ArrayList<String>();

        private MyFiler() {
        }

        public boolean matches(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            this.bodies.add(body);
            return !"secret".equals(body);
        }

        public List<String> getBodies() {
            return this.bodies;
        }
    }
}

