/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.processor.BodyInAggregatingStrategy;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
public class AggregatorWithBatchConsumingIssueTest
extends ContextTestSupport {
    @Test
    public void testAggregateLostGroupIssue() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(4);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"0+1+2");
        ((MockValueBuilder)mock.message(1).body()).isEqualTo((Object)"3+4+5");
        ((MockValueBuilder)mock.message(2).body()).isEqualTo((Object)"6+7+8");
        ((MockValueBuilder)mock.message(3).body()).isEqualTo((Object)"9+10+11");
        for (int i = 0; i < 12; ++i) {
            this.sendMessage(i);
        }
        this.assertMockEndpointsSatisfied();
    }

    private void sendMessage(final int index) {
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)index);
                exchange.getIn().setHeader("aggregateGroup", (Object)"group1");
                exchange.setProperty("CamelBatchSize", (Object)3);
                exchange.setProperty("CamelBatchIndex", (Object)(index % 3));
                exchange.setProperty("CamelBatchComplete", (Object)(index % 3 == 2 ? 1 : 0));
            }
        });
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((AggregateDefinition)this.from("direct:start").aggregate((Expression)this.header("aggregateGroup"), (AggregationStrategy)new BodyInAggregatingStrategy()).completionFromBatchConsumer().to("log:aggregated")).to("mock:result");
            }
        };
    }
}

