/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithWeaveByToUriToDTest
extends ContextTestSupport {
    @Test
    public void testAdviceToDToUri() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveByToUri("rest:get:foo/bar*").replace().to("mock:foo");
            }
        });
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceToDToString() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveByToString(".*rest:get:foo/bar/.*").replace().to("mock:foo");
            }
        });
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").toD("rest:get:foo/bar/{customerId}");
            }
        };
    }
}

