/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithUrlIssueTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("seda:test?concurrentConsumers=1").routeId("sedaroute").to("log:before")).to("mock:target");
            }
        };
    }

    @Test
    public void testProducerWithDifferentUri() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("sedaroute"), (CamelContext)this.context, (RouteBuilder)new Advice());
        this.getMockEndpoint("mock:target").expectedMessageCount(0);
        this.getMockEndpoint("mock:target2").expectedMessageCount(1);
        this.template.requestBody("seda:test", (Object)"TESTING");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testProducerWithSameUri() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("sedaroute"), (CamelContext)this.context, (RouteBuilder)new Advice());
        this.getMockEndpoint("mock:target").expectedMessageCount(0);
        this.getMockEndpoint("mock:target2").expectedMessageCount(1);
        this.template.requestBody("seda:test?concurrentConsumers=1", (Object)"TESTING");
        this.assertMockEndpointsSatisfied();
    }

    private static class Advice
    extends AdviceWithRouteBuilder {
        private Advice() {
        }

        public void configure() {
            this.interceptSendToEndpoint("mock:target").skipSendToOriginalEndpoint().to("mock:target2");
        }
    }
}

