/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Policy;
import org.junit.jupiter.api.Test;

public class AdviceWithTransactedTest
extends ContextTestSupport {
    @Test
    public void testAdviceTransacted() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:advice").expectedMessageCount(1);
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveAddFirst().to("mock:advice");
            }
        });
        this.template.sendBody("direct:advice", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((PolicyDefinition)this.from("direct:advice").policy((Policy)new MyDummyPolicy()).log("Advice ${body}")).to("mock:result");
            }
        };
    }

    private static final class MyDummyPolicy
    implements Policy {
        private MyDummyPolicy() {
        }

        public void beforeWrap(Route route, NamedNode definition) {
        }

        public Processor wrap(Route route, Processor processor) {
            return processor;
        }
    }
}

