/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Processor;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdviceWithStartTargetIssueTest
extends ContextTestSupport {
    @Test
    public void testAdvised() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)((RouteDefinition)this.context.getRouteDefinitions().get(0)), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                ((InterceptSendToEndpointDefinition)this.interceptSendToEndpoint("mock:foo").skipSendToOriginalEndpoint().to("log:foo")).to("mock:advised");
            }
        });
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:advised").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.getContext().getCamelContextExtension().addInterceptStrategy((InterceptStrategy)new ContainerWideInterceptor());
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:result");
            }
        };
    }

    static class ContainerWideInterceptor
    implements InterceptStrategy {
        private static final Logger LOG = LoggerFactory.getLogger(ContainerWideInterceptor.class);
        private static int count;

        ContainerWideInterceptor() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, final Processor target, Processor nextTarget) {
            return new DelegateAsyncProcessor(new Processor(){

                public void process(Exchange exchange) throws Exception {
                    LOG.info("I am the container wide interceptor. Intercepted total count: {}", (Object)(++count));
                    target.process(exchange);
                }

                public String toString() {
                    return "ContainerWideInterceptor[" + String.valueOf(target) + "]";
                }
            });
        }

        public int getCount() {
            return count;
        }
    }
}

