/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithRouteScopedErrorHandlerIssueTest
extends ContextTestSupport {
    @Test
    public void testAdviceWith() throws Exception {
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("route-a"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("direct:bar").skipSendToOriginalEndpoint().throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("route-a").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error")).to("direct:bar");
                this.from("direct:bar").routeId("route-b").to("mock:bar");
            }
        };
    }
}

