/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Test;

public class AdviceWithRoutePolicyTest
extends ContextTestSupport {
    @Test
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).header("MyRoutePolicy")).isEqualTo((Object)true);
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:bar").message(0).header("MyRoutePolicy")).isEqualTo((Object)true);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceRoutePolicyRemoved() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.getOriginalRoute().setRoutePolicies(null);
            }
        });
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).header("MyRoutePolicy")).isNull();
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        ((MockValueBuilder)this.getMockEndpoint("mock:bar").message(0).header("MyRoutePolicy")).isNull();
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routePolicy(new RoutePolicy[]{new MyRoutePolicy()}).to("mock:foo")).to("mock:bar");
            }
        };
    }

    private static class MyRoutePolicy
    extends RoutePolicySupport {
        private MyRoutePolicy() {
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            exchange.getIn().setHeader("MyRoutePolicy", (Object)true);
        }
    }
}

