/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PropertiesComponent;
import org.junit.jupiter.api.Test;

public class AdviceWithPropertyPlaceholderTest
extends ContextTestSupport {
    @Test
    public void testAdvicePropertyPlaceholder() throws Exception {
        Properties props = new Properties();
        props.put("myPattern", "seda*");
        props.put("myEnd", "mock:result");
        PropertiesComponent pc = this.context.getPropertiesComponent();
        pc.setInitialProperties(props);
        AdviceWith.adviceWith((CamelContext)this.context, null, r -> {
            r.mockEndpointsAndSkip(new String[]{"{{myPattern}}"});
            r.weaveAddLast().to("{{myEnd}}");
        });
        this.getMockEndpoint("mock:seda:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:seda:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:seda:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("seda:a")).to("seda:b")).to("seda:c");
            }
        };
    }
}

