/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithOnExceptionMultipleIssueTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(true).to("mock:error");
                this.from("direct:startA").routeId("RouteA").to("mock:resultA");
                this.from("direct:startB").routeId("RouteB").to("mock:resultB");
            }
        };
    }

    @Test
    public void testSimpleMultipleAdvice() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("RouteA"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("mock:resultA").process(new Processor(){

                    public void process(Exchange exchange) {
                    }
                });
            }
        });
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("RouteB"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:resultA").expectedMessageCount(1);
        this.template.sendBody("direct:startA", (Object)"a trigger");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMultipleAdviceWithExceptionThrown() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("RouteA"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("mock:resultA").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new Exception("my exception");
                    }
                });
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:resultA").expectedMessageCount(0);
        this.template.sendBody("direct:startA", (Object)"a trigger");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMultipleAdvice() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("RouteA"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("mock:resultA").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new Exception("my exception");
                    }
                });
            }
        });
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("RouteB"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:resultA").expectedMessageCount(0);
        this.template.sendBody("direct:startA", (Object)"a trigger");
        this.assertMockEndpointsSatisfied();
    }
}

