/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithOnCompletionRemoveTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAdviceOnCompletionRemove() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:done").expectedMessageCount(0);
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("foo"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveById("myCompletion").remove();
            }
        });
        this.context.start();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceOnCompletionReplace() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:done").expectedMessageCount(0);
        this.getMockEndpoint("mock:done2").expectedMessageCount(1);
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("foo"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveById("myCompletion").replace().onCompletion().to("mock:done2");
            }
        });
        this.context.start();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)((OnCompletionDefinition)this.onCompletion().id("myCompletion")).transform((Expression)this.constant("Bye World"))).to("mock:done");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("mock:c")).to("mock:d");
                ((RouteDefinition)this.from("direct:foo").routeId("foo").to("mock:a")).to("mock:b");
            }
        };
    }
}

