/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithIssueTest
extends ContextTestSupport {
    @Test
    public void testNoAdvice() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start", (Object)"Kaboom"), (String)"Should have thrown exception");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceWithErrorHandler() {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:dead"));
            }
        }), (String)"Should have thrown exception");
        Assertions.assertEquals((Object)"You can not advice with error handlers. Remove the error handlers from the route builder.", (Object)e.getMessage());
    }

    @Test
    public void testAdviceWithOnException() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.onException(IllegalArgumentException.class).handled(true).to("mock:error");
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Kaboom"});
        this.template.sendBody("direct:start", (Object)"World");
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceWithInterceptFrom() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.interceptFrom().to("mock:from");
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:from").expectedBodiesReceived(new Object[]{"World"});
        this.getMockEndpoint("mock:from").expectedPropertyReceived("CamelInterceptedEndpoint", (Object)"direct://start");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceWithInterceptSendToEndpoint() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.interceptSendToEndpoint("mock:result").to("mock:to");
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:to").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:to").expectedPropertyReceived("CamelInterceptedEndpoint", (Object)"mock://result");
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceWithOnCompletion() throws Exception {
        RouteDefinition route = (RouteDefinition)this.context.getRouteDefinitions().get(0);
        AdviceWith.adviceWith((RouteDefinition)route, (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.onCompletion().to("mock:done");
            }
        });
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:done").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).to("mock:result");
            }
        };
    }

    private static final class MyProcessor
    implements Processor {
        private MyProcessor() {
        }

        public void process(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("Kaboom".equals(body)) {
                throw new IllegalArgumentException("Kaboom");
            }
            exchange.getIn().setBody((Object)("Hello " + body));
        }
    }
}

