/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AdviceWithInvalidConfiguredTest
extends ContextTestSupport {
    @Test
    public void testNoErrorHandler() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("route-a"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler());
                this.interceptSendToEndpoint("direct:bar").skipSendToOriginalEndpoint().throwException((Exception)new IllegalArgumentException("Forced"));
            }
        }), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"You can not advice with error handlers. Remove the error handlers from the route builder.", (Object)e.getMessage());
    }

    @Test
    public void testNoExtraRoutes() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("route-a"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.from("direct:foo").to("mock:foo");
            }
        }), (String)"Should have thrown an exception");
        Assertions.assertEquals((Object)"You can only advice from a RouteBuilder which has no existing routes. Remove all routes from the route builder.", (Object)e.getMessage());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error"));
                this.from("direct:start").routeId("route-a").to("direct:bar");
                this.from("direct:bar").routeId("route-b").to("mock:bar");
            }
        };
    }
}

