/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithInterceptTest
extends ContextTestSupport {
    @Test
    public void testAdviceIntercept() throws Exception {
        this.getMockEndpoint("mock:advice").expectedMessageCount(1);
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("main"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveAddFirst().to("direct:advice");
            }
        });
        this.template.sendBody("direct:main", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.intercept().log("Intercept ${body}");
                ((RouteDefinition)this.from("direct:advice").log("Advice ${body}")).to("mock:advice");
                this.from("direct:main").routeId("main").log("Main ${body}");
            }
        };
    }
}

