/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.AdviceWith;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class AdviceWithInterceptRemoveTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testAdviceInterceptRemove() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:intercept").expectedMessageCount(0);
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("foo"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveById("myIntercept").remove();
            }
        });
        this.context.start();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testAdviceInterceptReplace() throws Exception {
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        this.getMockEndpoint("mock:d").expectedMessageCount(0);
        this.getMockEndpoint("mock:intercept").expectedMessageCount(0);
        this.getMockEndpoint("mock:intercept2").expectedMessageCount(1);
        AdviceWith.adviceWith((RouteDefinition)this.context.getRouteDefinition("foo"), (CamelContext)this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() {
                this.weaveById("myIntercept").replace().to("mock:intercept2");
            }
        });
        this.context.start();
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((InterceptDefinition)((InterceptDefinition)this.intercept().id("myIntercept")).transform((Expression)this.constant("Bye World"))).to("mock:intercept");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").to("mock:c")).to("mock:d");
                ((RouteDefinition)this.from("direct:foo").routeId("foo").to("mock:a")).to("mock:b");
            }
        };
    }
}

